---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：3-線形代数演算（Linear Algebra Operations）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **LAPACK/cuSOLVER連携の詳細**：根拠不足
  2. **Python高レベルAPIファイルパスの確認**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/linalg_ops.cc` - C++ op定義（行番号確認済み）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `tensorflow/core/framework/common_shape_fns.h` - 共通形状推論

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MakeBatchSquareMatrixが29-41行目に定義 | E-01 | ○ |
| C-02 | BatchUnchangedSquareShapeFnが43-48行目に定義 | E-01 | ○ |
| C-03 | BandedTriangularSolveShapeFnが51-91行目に定義 | E-01 | ○ |
| C-04 | MatrixDeterminant opが362行目で登録 | E-01 | ○ |
| C-05 | LogMatrixDeterminant opが380行目で登録 | E-01 | ○ |
| C-06 | MatrixInverse opが403行目で登録 | E-01 | ○ |
| C-07 | Cholesky opが424行目で登録 | E-01 | ○ |
| C-08 | Eig opが457行目で登録 | E-01 | ○ |
| C-09 | Lu opが474行目で登録 | E-01 | ○ |
| C-10 | MatrixSolve opが482行目で登録 | E-01 | ○ |
| C-11 | Qr opが533行目で登録 | E-01 | ○ |
| C-12 | Svd opが541行目で登録 | E-01 | ○ |
| C-13 | Einsum opが569行目で登録 | E-01 | ○ |
| C-14 | Batch接頭辞opが580行目以降で登録 | E-01 | ○ |
| C-15 | バンド数が行列サイズ以下でなければならない（61-69行目の検証） | E-01 | ○ |
| C-16 | すべての操作がバッチ次元をサポートする | E-01 | ○ |
| C-17 | GPU上でcuSOLVERを活用する | **根拠なし** | △ |
| C-18 | linalg_impl.pyがPython高レベルAPIを提供 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cuSOLVER連携の詳細はカーネル実装で確認が必要
  - 候補：`tensorflow/core/kernels/linalg/` 配下のカーネル
- Python高レベルAPIのファイルパスは実際のディレクトリ構造で確認が必要
  - 候補：`tensorflow/python/ops/linalg/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - C++ op定義の行番号は確認済み
- 1: 中リスク - カーネル実装の詳細は未確認
- 0: 低リスク - 形状推論関数の動作は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] linalg_ops.ccの行番号が現在のソースと一致しているか
- [ ] Python側のlinalg APIパスが正確か
- [ ] カーネル実装（LAPACK/cuSOLVER）の記述が正確か
- [ ] Batch系レガシーopの記述が正確か
